unit UDemoBDE;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MRViewer, Db, DBTables, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MRViewer: TMRViewer;
    Button1: TButton;
    Table: TTable;
    ProgressBar: TProgressBar;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    RGType: TRadioGroup;
    RGReport: TRadioGroup;
    Query2: TQuery;
    Table3: TTable;
    Query3: TQuery;
    procedure Button1Click(Sender: TObject);
    procedure MRViewerGetDataSet(Name: String; IsMain: Boolean;
      DetailInternalName: String; var FDataSet: TDataSet);
    procedure MRViewerProgress(Position: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
    try
        if RGType.ItemIndex = 0 then
        begin
           case RGReport.ItemIndex of
             0: MRViewer.LoadReport('..\..\Reports\DemoGraph1.mrp');
             1: MRViewer.LoadReport('..\..\Reports\DemoGraph2.mrp');
             2: MRViewer.LoadReport('..\..\Reports\DemoGraph3.mrp');
           end;
        end
        else
        begin
           case RGReport.ItemIndex of
             0: MRViewer.LoadReport('..\..\Reports\Demo1.mrp');
             1: MRViewer.LoadReport('..\..\Reports\Demo2.mrp');
             2: MRViewer.LoadReport('..\..\Reports\Demo3.mrp');
           end;
        end;

        MRViewer.Preview;
    finally
        MRViewer.UnLoadReport;
    end;
end;

procedure TForm1.MRViewerGetDataSet(Name: String; IsMain: Boolean;
  DetailInternalName: String; var FDataSet: TDataSet);
begin
    case RGReport.ItemIndex of
      0: FDataSet := Table;

      1: FDataSet := Query2;

      2: begin
            if IsMain then
                FDataSet := Table3
            else // detail
            begin
                Query3.Active := False;
                Query3.SQL.Clear;
                Query3.SQL.Add('select * from  parts where VendorNo=' + Table3.FieldByName('VendorNo').AsString);
                Query3.Active := True;
                FDataSet := Query3;
            end;
         end;   
    end;
end;

procedure TForm1.MRViewerProgress(Position: Integer);
begin
    ProgressBar.Position := Position;
end;

end.
